* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* Table 2 (data row)

* From the macro data, compute first three moments reported in table
use year sd_TFP RK RI R_frac using "$datapath/macrodata_coopimmo.dta", clear
collapse (mean) R_frac RK sd_TFP
save tmp1.dta, replace 

* From the micro data, compute four untargeted moments
use id year s R RK adj_R TFP APK using "$datapath/microdata_coopimmo.dta", clear
* Compute auto-correlation of firm-level sales
sort id year
gen lns = log(s)
reghdfe lns l.lns, absorb(id year)
* Save regression coefficient
gen AR1_sales = _b[l.lns] 
drop lns 

* Serial correlation of plant-level capital reallocation rates
* Remove unrealistically high plant-level reallocation rates
replace RK 	= . if RK > 1.5 
reghdfe RK l.RK, absorb(id year)
gen AR1_reallo = _b[l.RK] 
* AR(1) of R/K  --> * Gives .0036434 


* Micro-level correlations between productivity and reallocation
pwcorr RK APK, star(.01)
gen c_APK_R = r(rho)


* Importance of small capital reallocation 
* Make a statement about positive reallocation

keep if R > 0 & R < .
* Every year, sort firms by reallocation
* Find the fraction of FIRMS that represents 10% of adjustments each year
* Then take the average of that number across years
sort year R
bys year: egen R_sum = total(R)
sort year R
gen tmp = R / R_sum 
bys year: gen R_frac = sum(tmp)
drop R_sum tmp 

* Find fraction of firms
bys year: gen n = _n
bys year: gen N = _N
gen F_sum = n / N 
drop n N 

* Find firm closest to 10% every year
gen tmp = abs(R_frac - .1)
bys year: egen target = min(tmp)
gen p10_firm = tmp == target 
keep if p10_firm == 1
drop id tmp target p10_firm

ren F_sum smallRK

collapse (mean) AR1_sales AR1_reallo c_APK_R smallRK

* Add the first three moments back
append using tmp1.dta
erase tmp1.dta

save "$mainpath/Tables/Tables_data/Table2.dta", replace
